/*
 * TESLA: A Transparent, Extensible Session-Layer Architecture
 *
 * Jon Salz <jsalz@mit.edu>
 * Alex C. Snoeren <snoeren@lcs.mit.edu>
 *
 * Copyright (c) 2001-2 Massachusetts Institute of Technology.
 *
 * This software is being provided by the copyright holders under the GNU
 * General Public License, either version 2 or, at your discretion, any later
 * version. For more information, see the `COPYING' file in the source
 * distribution.
 *
 * $Id: crypt_handler.hh,v 1.3 2002/08/30 20:35:36 jsalz Exp $
 *
 * A really dumb triple-DES encryption handler.
 *
 */

#ifndef HH_CRYPT_HANDLER
#define HH_CRYPT_HANDLER

#include "tesla/flow_handler.hh"

#include <cctype>

#include <sys/socket.h>

#include "openssl/md5.h"
#include "openssl/des.h"

class crypt_handler : public flow_handler {
    des_cblock key;

    des_key_schedule in1_sched;
    des_key_schedule in2_sched;
    des_key_schedule in3_sched;
    des_cblock in_ivec;
    int in_num;
    des_key_schedule out1_sched;
    des_key_schedule out2_sched;
    des_key_schedule out3_sched;
    des_cblock out_ivec;
    int out_num;

public:
    crypt_handler(init_context& ctxt) : flow_handler(ctxt) {
	memset(&key, 0, sizeof key);
	des_set_odd_parity(&key);
	memcpy(&in_ivec, &key, sizeof in_ivec);
	memcpy(&out_ivec, &key, sizeof out_ivec);
	des_set_key(&in_ivec, in1_sched);
	des_set_key(&in_ivec, in2_sched);
	des_set_key(&in_ivec, in3_sched);
	des_set_key(&out_ivec, out1_sched);
	des_set_key(&out_ivec, out2_sched);
	des_set_key(&out_ivec, out3_sched);

	in_num = out_num = 0;
    }

    virtual bool avail(flow_handler *from, data d) {
	static char tmpbuf[65536*16];
	assert(d.length() <= sizeof tmpbuf);

	des_ede3_cfb64_encrypt((unsigned char *)d.bits(), (unsigned char *)tmpbuf, d.length(),
			       in1_sched, in2_sched, in3_sched, &in_ivec, &in_num, DES_DECRYPT);

	return get_upstream().avail(this, data(tmpbuf, d.length()));
    }

    virtual int write(data d) {
	static char tmpbuf[65536*16];
	assert(d.length() <= sizeof tmpbuf);

	des_ede3_cfb64_encrypt((unsigned char *)d.bits(), (unsigned char *)tmpbuf, d.length(),
			       out1_sched, out2_sched, out3_sched, &out_ivec, &out_num, DES_ENCRYPT);

	return downstream[0]->write(data(tmpbuf, d.length()));
    }

    DECLARE_HANDLER;
};

#endif
