/*
 * TESLA: A Transparent, Extensible Session-Layer Architecture
 *
 * Jon Salz <jsalz@mit.edu>
 * Alex C. Snoeren <snoeren@lcs.mit.edu>
 *
 * Copyright (c) 2001-2 Massachusetts Institute of Technology.
 *
 * This software is being provided by the copyright holders under the GNU
 * General Public License, either version 2 or, at your discretion, any later
 * version. For more information, see the `COPYING' file in the source
 * distribution.
 *
 * $Id: latency_handler.hh,v 1.2 2002/09/04 18:41:46 jsalz Exp $
 *
 * A handler which simulates latency.
 *
 */

#ifndef HH_SHAPE_HANDLER
#define HH_SHAPE_HANDLER

#include "tesla/flow_handler.hh"
#include "tesla/timer.hh"

#include <sys/socket.h>

#include <list>

class latency_handler : public flow_handler {
    typedef long long time;

    // pkt = time to write, plus data to write
    typedef pair<time, string> pkt;
    typedef method_timer<latency_handler> my_timer;

    // Amount of time to delay
    my_timer  rtimer, wtimer;
    time      rdelay, wdelay;
    list<pkt> rpkts, wpkts;

public:
    latency_handler(init_context& ctxt, bool plumb = true);
    bool avail(flow_handler *from, data d);
    int write(data d);
    void may_write(flow_handler *from, bool may);
    void may_avail(bool may);
    bool may_exit();

protected:
    void rfire(my_timer&);
    void wfire(my_timer&);

    DECLARE_HANDLER;
};

#endif
