/*
 * TESLA: A Transparent, Extensible Session-Layer Architecture
 *
 * Jon Salz <jsalz@mit.edu>
 * Alex C. Snoeren <snoeren@lcs.mit.edu>
 *
 * Copyright (c) 2001-2 Massachusetts Institute of Technology.
 *
 * This software is being provided by the copyright holders under the GNU
 * General Public License, either version 2 or, at your discretion, any later
 * version. For more information, see the `COPYING' file in the source
 * distribution.
 *
 * $Id: log_handler.hh,v 1.4 2002/08/30 20:35:37 jsalz Exp $
 *
 * A handler which logs events to stderr or a file.
 *
 */

#ifndef HH_LOG_HANDLER
#define HH_LOG_HANDLER

#include "tesla/flow_handler.hh"

#include <map>
#include <iostream>
#include <fstream>

class log_handler : public flow_handler
{
    typedef pair<string, log_handler*> logpair;
    typedef multimap<string, log_handler*> logmap;

    static int count;
    static logmap logs;

    int id;
    ostream *out;

    string outname;
    ofstream *outfile;

    bool log_write;
    bool log_avail;
    bool log_all;

    enum mode_t {
	READABLE,
	CSTRING,
	HEX,

	DEFAULT = READABLE
    };
    mode_t mode;

public:
    log_handler(const init_context& ctxt, bool plumb = true);
    virtual ~log_handler();
    int write(data d);
    bool avail(flow_handler *from, data d);
    int shutdown(bool r, bool w);

protected:
    void log(string str);
    string to_string(int i);
    string to_string(data d);

    DECLARE_HANDLER;
};

#endif
