
#ifndef HH_MSG_HANDLER
#define HH_MSG_HANDLER

#include "flow_handler.hh"
#include "timer.hh"

#include <cctype>

#include <sys/socket.h>
#include <unistd.h>
#include <sys/stat.h>
#include <fcntl.h>

class msg_handler : public flow_handler {
    typedef method_timer<msg_handler> my_timer;
    my_timer timer1;

public:
    msg_handler(init_context& ctxt, bool plumb = true) :
	flow_handler(ctxt, plumb),
	timer1(this, &msg_handler::go)
    {
	timer1.arm(500000LL);
    }

    void go(my_timer& t) {
	ts_error("Woohoo!");
	if (messages_enabled()) {
	    ts_error("Messages are enabled... sending message");
	    message(12345, "FOO BAR!!!");
	    int fd = ::open("/etc/passwd", O_RDONLY);
	    message_fd(23456, fd);
	    ::close(fd);
	}
	timer1.arm(2000000LL);
    }

    int ioctl(string target, int optname, string value, string& out) {
	ts_error("Ioctl!");
	int fd = ::open("/etc/passwd", O_RDONLY);
	int ret = encode_pass_fd(fd, out);
	return ret;
    }

    DECLARE_HANDLER;
};

#endif
