/*
 * TESLA: A Transparent, Extensible Session-Layer Architecture
 *
 * Jon Salz <jsalz@mit.edu>
 * Alex C. Snoeren <snoeren@lcs.mit.edu>
 *
 * Copyright (c) 2001-2 Massachusetts Institute of Technology.
 *
 * This software is being provided by the copyright holders under the GNU
 * General Public License, either version 2 or, at your discretion, any later
 * version. For more information, see the `COPYING' file in the source
 * distribution.
 *
 * $Id: shape_handler.hh,v 1.3 2002/08/30 20:35:37 jsalz Exp $
 *
 * A handler which shapes incoming and/or outgoing traffic by limiting it to
 * a certain number of bytes per timeslice.
 *
 */

#ifndef HH_SHAPE_HANDLER
#define HH_SHAPE_HANDLER

#include "tesla/flow_handler.hh"
#include "tesla/timer.hh"

#include <sys/socket.h>

class shape_handler : public flow_handler {
    typedef method_timer<shape_handler> my_timer;

    my_timer  rtimer, wtimer;
    string    rbuf, wbuf;

    // Length in us of each slice
    long long slice;
    // Bytes allowed in each slice
    int       rmeter, wmeter;

    // Number of bytes read this slice
    unsigned int rbytes, wbytes;

public:
    shape_handler(init_context& ctxt, bool plumb = true);
    bool avail(flow_handler *from, data d);
    int write(data d);

protected:
    void rfire(my_timer&);
    void wfire(my_timer&);

    DECLARE_HANDLER;
};

#endif
