/*
 * TESLA: A Transparent, Extensible Session-Layer Architecture
 *
 * Jon Salz <jsalz@mit.edu>
 * Alex C. Snoeren <snoeren@lcs.mit.edu>
 *
 * Copyright (c) 2001-2 Massachusetts Institute of Technology.
 *
 * This software is being provided by the copyright holders under the GNU
 * General Public License, either version 2 or, at your discretion, any later
 * version. For more information, see the `COPYING' file in the source
 * distribution.
 *
 * $Id: socks_handler.hh,v 1.5 2002/08/30 20:35:37 jsalz Exp $
 *
 * A simple SOCKS flow handler.
 *
 */

#ifndef HH_SOCKS_HANDLER
#define HH_SOCKS_HANDLER

#include "tesla/buf_handler.hh"

#include <sys/socket.h>

class socks_handler : public buf_handler {
    enum state_t {
	NOTHING,
	CONNECTING,
	WAITING_METHOD,
	WAITING_REPLY,
	WAITING_REPLY_2,
	ESTABLISHED
    };

    state_t state;

    string inbuf;
    address proxy, peer;

    void reset() {
        ts_debug_1("Resetting");
        downstream[0]->close();
        upstream->connected(this, false);
        state = NOTHING;
    }

public:
    socks_handler(init_context& ctxt, bool plumb = true);
    int bind(address a);
    int listen(int backlog);
    acceptret accept();
    bool avail(flow_handler *h, data d);
    int connect(address a);
    void connected(flow_handler *from, bool success);
    int write(data d);

    DECLARE_HANDLER;
};

#endif
