/*
 * TESLA: A Transparent, Extensible Session-Layer Architecture
 *
 * Jon Salz <jsalz@mit.edu>
 * Alex C. Snoeren <snoeren@lcs.mit.edu>
 *
 * Copyright (c) 2001-2 Massachusetts Institute of Technology.
 *
 * This software is being provided by the copyright holders under the GNU
 * General Public License, either version 2 or, at your discretion, any later
 * version. For more information, see the `COPYING' file in the source
 * distribution.
 *
 * $Id: state_handler.hh,v 1.2 2002/10/04 03:38:37 jsalz Exp $
 *
 * A state handler, useful for testing.
 *
 */

#ifndef HH_STATE_HANDLER
#define HH_STATE_HANDLER

#include "tesla/flow_handler.hh"
#include "tesla/default_handler.hh"

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/socket.h>
#include <unistd.h>

class state_handler : public flow_handler {
public:
    state_handler(init_context& ctxt) : flow_handler(ctxt) {
	if (ctxt.serial()) {
	    string val;
	    *ctxt.serial() >> val;
	    ts_debug_1("state_handler said: %s", val.c_str());

	    // Just for kicks, let this socket be the /etc/passwd file
	    // In Migrate, this would be the fd obtained from the
	    // Migrate daemon using the token written by save_state
	    int fd = open("/etc/passwd", O_RDONLY);

	    downstream.push_back(new default_handler(this, fd));
	}
    }

    int write(data d) {
	upstream->may_write(this, false);
	return 0;
    }

    bool save_state(oserial& out) const {
	ts_debug_1("In state_handler::save_state");

	// Just for kicks, write some state.
	//
	// Migrate would probably pass the file descriptor
	// static_cast<default_handler*>(downstream)->get_fd()
	// to the Migrate daemon, and to out write a token
	// that it could later use to retrieve the FD
	out << string("I ain't gots no state!");

	return out;
    }

    DECLARE_HANDLER;
};

#endif
