/*
 * TESLA: A Transparent, Extensible Session-Layer Architecture
 *
 * Jon Salz <jsalz@mit.edu>
 * Alex C. Snoeren <snoeren@lcs.mit.edu>
 *
 * Copyright (c) 2001-2 Massachusetts Institute of Technology.
 *
 * This software is being provided by the copyright holders under the GNU
 * General Public License, either version 2 or, at your discretion, any later
 * version. For more information, see the `COPYING' file in the source
 * distribution.
 *
 * $Id: async.hh,v 1.6 2002/08/30 20:35:37 jsalz Exp $
 *
 * The multiplexor for I/O events.
 *
 */

#ifndef HH_ASYNC
#define HH_ASYNC

#include <vector>

#include <unistd.h>

#include "tesla/tesla.h"

using namespace std;

class async
{
private:

    int fd;

    typedef vector<async*> hvec;
    static hvec handlers;
    static fd_set readfds;
    static fd_set writefds;
    static fd_set rr;
    static fd_set ww;
    static int maxfd;

    static int inited;

    static int init() {
	FD_ZERO(&readfds);
	FD_ZERO(&writefds);
	handlers.resize(FD_SETSIZE, 0);
	return 1;
    }	

public:
    async(int _fd = -1) : fd(-1) {
	set_fd(_fd);
    }
    virtual ~async() {
	if (fd >= 0) {
	    handlers[fd] = 0;
	    FD_CLR(fd, &readfds);
	    FD_CLR(fd, &writefds);
	}
    }

    void set_fd(int _fd) {
	if (fd != -1)
	    handlers[fd] = 0;

	fd = _fd;
	if (fd > maxfd)
	    maxfd = fd;

	if (fd != -1)
	    handlers[fd] = this;
    }

    void set_ractive(bool act) {
	assert(fd >= 0);
	if (act) {
	    ts_debug_2("Activating read on %d", fd);
	    FD_SET(fd, &readfds);
	}
	else {
	    ts_debug_2("Deactivating read on %d", fd);
	    FD_CLR(fd, &readfds);
	    // Even if it tripped our current select, ignore it
	    FD_CLR(fd, &rr);
	}
    }
    void set_wactive(bool act) {
	assert(fd >= 0);
	if (act) {
	    ts_debug_2("Activating write on %d", fd);
	    FD_SET(fd, &writefds);
	}
	else {
	    ts_debug_2("Deactivating write on %d", fd);
	    FD_CLR(fd, &writefds);
	    // Even if it tripped our current select, ignore it
	    FD_CLR(fd, &ww);
	}
    }

    virtual void ravail() {}
    virtual void wavail() {}

    static void select();
};

#endif
