
#ifndef HH_BUF_HANDLER
#define HH_BUF_HANDLER

#include "tesla/flow_handler.hh"

class buf_handler : public flow_handler
{
    string wbuf;

public:
    buf_handler(const init_context& ctxt, bool plumb = true) :
	flow_handler(ctxt, plumb)
    {
    }

protected:
    int bufwrite(data d) {
	if (may_write_now())
	    return flow_handler::write(d);

	wbuf.append(d.bits(), d.length());
	return 0;
    }

public:
    void may_write(flow_handler *from, bool may) {
	if (may == true && wbuf.length() != 0) {
	    downstream[0]->write(data(wbuf.data(), wbuf.length()));
	    wbuf.erase();
	}
	flow_handler::may_write(from, may);
    }
};

#endif
