/*
 * TESLA: A Transparent, Extensible Session-Layer Architecture
 *
 * Jon Salz <jsalz@mit.edu>
 * Alex C. Snoeren <snoeren@lcs.mit.edu>
 *
 * Copyright (c) 2001-2 Massachusetts Institute of Technology.
 *
 * This software is being provided by the copyright holders under the GNU
 * General Public License, either version 2 or, at your discretion, any later
 * version. For more information, see the `COPYING' file in the source
 * distribution.
 *
 * $Id: client.hh,v 1.7 2002/09/02 18:38:16 jsalz Exp $
 *
 * Handles a single client in the master process.
 *
 */

#ifndef HH_CLIENT
#define HH_CLIENT

#include "tesla/async.hh"

class client : protected async {
protected:
    int fd;
    bool messages_enabled;
    int msg_fd_remote;
    int msg_fd;
    bool inessential;

public:
    client(int _fd) : async(_fd), fd(_fd), messages_enabled(false),
		      msg_fd_remote(-1), msg_fd(-1),
		      inessential(false)
    {
	set_ractive(true);
    }

    virtual ~client() {
	close(fd);
	if (msg_fd_remote >= 0) close(msg_fd_remote);
	if (msg_fd >= 0) close(msg_fd);
    }

    virtual void ravail();

    bool are_messages_enabled() { return messages_enabled; }
    int get_msg_fd() { return msg_fd; }
    bool is_inessential() { return inessential; }

protected:
    void set_inessential(bool i) { inessential = i; }
};

#endif
