/*
 * TESLA: A Transparent, Extensible Session-Layer Architecture
 *
 * Jon Salz <jsalz@mit.edu>
 * Alex C. Snoeren <snoeren@lcs.mit.edu>
 *
 * Copyright (c) 2001-2 Massachusetts Institute of Technology.
 *
 * This software is being provided by the copyright holders under the GNU
 * General Public License, either version 2 or, at your discretion, any later
 * version. For more information, see the `COPYING' file in the source
 * distribution.
 *
 * $Id: default_handler.hh,v 1.2 2002/10/08 19:03:33 snoeren Exp $
 *
 * The default handler, which handles communication between the master
 * process and the network.
 *
 */

#ifndef HH_DEFAULT_HANDLER
#define HH_DEFAULT_HANDLER

#include "tesla/async.hh"
#include "tesla/flow_handler.hh"

#include <cerrno>
#include <fcntl.h>
#include <unistd.h>

using namespace std;

class default_handler : public flow_handler, async
{
private:
    int fd;

    enum {
	NONE,
	BOUND,
	LISTENING,
	LISTENING_AVAIL,
	CONNECTING,
	CONNECTED,
	STOP_READING,
	CLOSED
    } state;

    string buffer;

    bool write_shutdown;

public:
    default_handler(flow_handler *upstream, int _fd);
    default_handler(init_context& ctxt, int _fd = -1);

    void ravail();
    void wavail();

    bool avail(flow_handler *from, data d);
    int connect(address a);
    int bind(address a);
    acceptret accept();
    int close();
    int write(data d);
    int shutdown(bool r, bool w);
    int listen(int backlog);
    address getsockname();
    address getpeername();
    string getsockopt(int level, int optname, int maxlen);
    int setsockopt(int level, int optname, string value);
    int ioctl(string target, int optname, string value, string& out);

    void may_avail(bool may);

    bool save_state(oserialstream& out) { return false; }

    virtual void dump(string& out, int indent = 0);
};

#endif
