/*
 * TESLA: A Transparent, Extensible Session-Layer Architecture
 *
 * Jon Salz <jsalz@mit.edu>
 * Alex C. Snoeren <snoeren@lcs.mit.edu>
 *
 * Copyright (c) 2001-2 Massachusetts Institute of Technology.
 *
 * This software is being provided by the copyright holders under the GNU
 * General Public License, either version 2 or, at your discretion, any later
 * version. For more information, see the `COPYING' file in the source
 * distribution.
 *
 * $Id: async.cc,v 1.6 2002/09/11 18:31:54 snoeren Exp $
 *
 * The multiplexor for I/O events.
 *
 */

#include "config.h"

#include "tesla/async.hh"
#include "tesla/timer.hh"
#include <sys/select.h>
#include <sys/time.h>

async::hvec async::handlers;
fd_set async::readfds;
fd_set async::writefds;
fd_set async::rr;
fd_set async::ww;
int async::maxfd = -1;
int async::inited = async::init();

void async::select()
{
    ts_debug_2("In select");
    
    memcpy(&rr, &readfds, sizeof(fd_set));
    memcpy(&ww, &writefds, sizeof(fd_set));

    long long next = timer::fire_all();

    ts_debug_2("Fire all says next timer in %lld", next);

    if (next == timer::CLEAR)
	::select(maxfd+1, &rr, &ww, 0, 0);
    else {
	struct timeval tv = { next / 1000000, next % 1000000 };
	::select(maxfd+1, &rr, &ww, 0, &tv);
    }    
    
    for (int i = 0; i <= maxfd; ++i) {
	if (handlers[i]) {
	    if (FD_ISSET(i, &rr)) {
		ts_debug_2(" - read event on %d", i);
		handlers[i]->ravail();
	    }
	    if (FD_ISSET(i, &ww)) {
		ts_debug_2(" - write event on %d", i);
		// It is possible the read event closed down the handler
		if(handlers[i])
		  handlers[i]->wavail();
	    }
	}
    }
}
