/*
 * TESLA: A Transparent, Extensible Session-Layer Architecture
 *
 * Jon Salz <jsalz@mit.edu>
 * Alex C. Snoeren <snoeren@lcs.mit.edu>
 *
 * Copyright (c) 2001-2 Massachusetts Institute of Technology.
 *
 * This software is being provided by the copyright holders under the GNU
 * General Public License, either version 2 or, at your discretion, any later
 * version. For more information, see the `COPYING' file in the source
 * distribution.
 *
 * $Id: common.c,v 1.12 2002/09/30 16:57:52 jsalz Exp $
 *
 * Constructs used by both libtesla.so and the master process.
 *
 */

#include "config.h"

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>

#include "tesla.h"

// Message types - used for debugging
const char *__ts_msg_types[] = {
    "HELLO",
    "SOCKET",
    "CONNECT",
    "FH_FOLLOWS",
    "ACK",
    "NAK",
    "BIND",
    "LISTEN",
    "ACCEPT",
    "GETSOCKOPT",
    "SETSOCKOPT",
    "GETPEERNAME",
    "GETSOCKNAME",
    "ASYNC_MESSAGES",
    "FORK",
    "INESSENTIAL",
    "SAVE_STATE",
    "GET_FD"
};
const int __ts_msg_type_count = sizeof __ts_msg_types / sizeof __ts_msg_types[0];

// Used by TS_CALL_LIBC and TS_APPLY_LIBC to store the handle to the
// libc dynamic library
void *__ts_libc;

/* Debugging support. */

int __ts_debug_level = 0;
FILE* __ts_debug_file = 0;
int __ts_disable_debug = 0;

void __ts_debug_init() {
    static int run_yet = 0;

    if (!run_yet)
    {
	char *value = getenv("TS_DEBUG");

	__ts_debug_level = value ? atoi(value) : 0;
	if (__ts_debug_level < 0)
	    __ts_debug_level = 0;

	value = getenv("TS_DEBUG_FILE");
	if (value)
	    __ts_debug_file = fopen(value, "a");

	run_yet = 1;

	if (__ts_debug_file)
	{
	    fprintf(__ts_debug_file, "\n**********\n\n");
	    ts_debug_2("Writing debug output to \"%s\"", value);
	}
	else
	{
	    __ts_debug_file = stderr;
	    if (value)
		ts_error("Unable to open debug file \"%s\"", value);
	}

	ts_debug_2("Debug level set to %d", __ts_debug_level);
    }
}

void __ts_debug_i(int level, char *file, int line, char *fmt, ...)
{
    static int disable = 0;

    if (__ts_disable_debug) return;

    __ts_debug_init();

    if (__ts_debug_level >= level)
    {
	va_list ap;
	va_start(ap, fmt);

	if (!disable) {
	    ++disable;
	    fprintf(__ts_debug_file, "[%-18s:%3d] ", file, line);
	    vfprintf(__ts_debug_file, fmt, ap);
	    fprintf(__ts_debug_file, "\n");
	    fflush(__ts_debug_file);
	    --disable;
	}
    }
}
