/*
 * TESLA: A Transparent, Extensible Session-Layer Architecture
 *
 * Jon Salz <jsalz@mit.edu>
 * Alex C. Snoeren <snoeren@lcs.mit.edu>
 *
 * Copyright (c) 2001-2 Massachusetts Institute of Technology.
 *
 * This software is being provided by the copyright holders under the GNU
 * General Public License, either version 2 or, at your discretion, any later
 * version. For more information, see the `COPYING' file in the source
 * distribution.
 *
 * $Id: top_handler.hh,v 1.8 2002/10/04 03:01:08 jsalz Exp $
 *
 * The top handler, which handles communication between the
 * application and the master process.
 *
 */

#ifndef HH_TOP_HANDLER
#define HH_TOP_HANDLER

#include "tesla/async.hh"
#include "tesla/flow_handler.hh"
#include <string>

using namespace std;

class top_handler : private async, public flow_handler {
private:
    int fd;
    int conn_id;
    flow_handler *h;
    string buffer;
    int type;

    static info _info;

    // Never write again to application, e.g., application has called
    // shutdown(fd, SHUT_RD)
    bool shut_read;

    // Never read from application again, e.g., application has called
    // shutdown(fd, SHUT_WR)
    bool shut_write;

    // Connected?  (If not, delete this on shut_write)
    bool is_connected;

    bool closed;

    void check_shutdown();
    bool sendapp_or_buffer(const void *pp, int len);

public:
    top_handler(int _fd, int _type, int _conn_id, flow_handler *_h);
    virtual ~top_handler();
    virtual int close();

    int get_fd() { return fd; }
    int get_conn_id() { return conn_id; }

    void set_fd(int fd) { this->fd = fd; async::set_fd(fd); set_ractive(true); }
    void set_conn_id(int conn_id) { this->conn_id = conn_id; }

    flow_handler *get_handler() { return h; }

    void sigpipe();

    virtual void ravail();
    virtual void wavail();
    virtual void connected(flow_handler *from, bool success);
    virtual void accept_ready(flow_handler *from);
    string getsockopt(int level, int optname, int maxlen);
    int setsockopt(int level, int optname, string value);
    int ioctl(string target, int optname, string value, string& out);
    address getpeername();
    address getsockname();

    virtual bool avail(flow_handler *from, data d);
    virtual void may_write(flow_handler *from, bool may);
    virtual bool may_exit();

    virtual bool save_state(oserial& out) const {
	return out << *h;
    }

    void rewant() {
	set_ractive(may_write_now());
    }
};

#endif
